<?php

namespace App\Http\Resources\Api;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class BannerResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id'=>$this->id,
            'photo'=>asset('photo/'.$this->photo),
            'from'=>$this->from,
            'to'=>$this->to,
            'available'=>$this->available,
            'price'=>$this->price,
        ];
    }
}
