<?php

namespace App\Http\Resources\Api;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CategoryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id'=>$this->id,
            'photo'=>asset('photo/'.$this->photo),
            'name'=>app()->getLocale() == 'ar' ? $this->name : $this->name_en,
            'items'=>ItemResource::collection($this->items),
            'created_at'=>date("Y-m-d",strtotime($this->created_at)),
            'updated_at'=>date("Y-m-d",strtotime($this->updated_at)),
        ];
        //return parent::toArray($request);
    }
}
